jQuery(document).ready(function ($) {
    const $form = $('#fsc-search-form');
    const $baseDir = $('#fsc-base-dir');
    const $customPath = $('#fsc-custom-path');
    const $progress = $('#fsc-progress');
    const $progressBar = $('#fsc-progress-bar');
    const $resultsHeading = $('#fsc-results-heading');
    const $resultsTable = $('#fsc-results-table');
    const $tbody = $resultsTable.find('tbody');
    const $exportCsv = $('#fsc-export-csv');
    const $exportJson = $('#fsc-export-json');
    const $exportActions = $('.fsc-export-actions');

    let lastResults = [];

    // Show/hide custom path field
    $baseDir.on('change', function () {
        if ($(this).val() === 'custom') {
            $customPath.show();
        } else {
            $customPath.hide();
        }
    });

    // Form submit
    $form.on('submit', function () {
        const data = {
            action: 'fsc_search_code',
            nonce: FSC_Admin.nonce,
            search_text: $('#fsc-search-text').val(),
            base_dir: $baseDir.val(),
            custom_path: $customPath.val(),
            extensions: $('#fsc-extensions').val(),
            case_sensitive: $('#fsc-case-sensitive').is(':checked'),
            regex: $('#fsc-regex').is(':checked'),
            max_depth: $('#fsc-max-depth').val()
        };

        // Reset UI
        $tbody.empty();
        $resultsHeading.hide();
        $resultsTable.hide();
        $exportActions.hide();
        lastResults = [];

        // Show progress
        $progress.show();
        $progressBar.css({ width: '10%' });

        $.post(FSC_Admin.ajax_url, data, function (response) {
            $progressBar.css({ width: '100%' });
            $progress.fadeOut(300);
            if (response.success) {
                renderResults(response.data);
            } else {
                alert(response.data || 'Error');
            }
        }).fail(function () {
            $progress.fadeOut();
            alert('AJAX error');
        });
    });

    function renderResults(results) {
        lastResults = results;
        if (results.length === 0) {
            alert('No matches found');
            return;
        }

        $.each(results, function (i, row) {
            const tr = $('<tr/>');
            tr.append($('<td/>').text(row.file));
            tr.append($('<td/>').text(row.line));
            tr.append($('<td/>').html(row.snippet));
            $tbody.append(tr);
        });

        $resultsHeading.show();
        $resultsTable.show();
        $exportActions.show();
    }

    // Export CSV
    $exportCsv.on('click', function () {
        if (!lastResults.length) return;
        let csv = '"File","Line","Snippet"\n';
        lastResults.forEach(function (r) {
            csv += `"${r.file}","${r.line}","${r.snippet.replace(/"/g, '""')}"\n`;
        });
        downloadFile(csv, 'filescan-results.csv', 'text/csv');
    });

    // Export JSON
    $exportJson.on('click', function () {
        if (!lastResults.length) return;
        const json = JSON.stringify(lastResults, null, 2);
        downloadFile(json, 'filescan-results.json', 'application/json');
    });

    function downloadFile(dataStr, fileName, mime) {
        const blob = new Blob([dataStr], { type: mime });
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = fileName;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
    }
}); 