<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap fsc-admin-page">
    <h1><?php esc_html_e( 'File Scan Code Search', 'file-scan-code-search' ); ?></h1>

    <h2 class="nav-tab-wrapper" style="margin-bottom: 12px;">
        <a href="<?php echo esc_url( $fscs_tab_urls['search'] ); ?>" class="nav-tab <?php echo ( 'search' === $fscs_tab ) ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e( 'Search', 'file-scan-code-search' ); ?>
        </a>
        <a href="<?php echo esc_url( $fscs_tab_urls['advanced'] ); ?>" class="nav-tab <?php echo ( 'advanced' === $fscs_tab ) ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e( 'Advanced', 'file-scan-code-search' ); ?>
        </a>
        <a href="<?php echo esc_url( $fscs_tab_urls['help'] ); ?>" class="nav-tab <?php echo ( 'help' === $fscs_tab ) ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e( 'Help', 'file-scan-code-search' ); ?>
        </a>
    </h2>

    <?php if ( 'search' === $fscs_tab ) : ?>
<form id="fsc-search-form" method="post" onsubmit="return false;">
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="fsc-search-text"><?php esc_html_e( 'Search Text', 'file-scan-code-search' ); ?></label></th>
                    <td><input type="text" id="fsc-search-text" class="regular-text" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="fsc-base-dir"><?php esc_html_e( 'Directory', 'file-scan-code-search' ); ?></label></th>
                    <td>
                        <select id="fsc-base-dir">
<?php foreach ( (array) $locations as $fsc_key => $fsc_item ) : ?>
    <option value="<?php echo esc_attr( $fsc_key ); ?>" <?php disabled( empty( $fsc_item['enabled'] ) ); ?>>
        <?php echo esc_html( $fsc_item['label'] ); ?><?php if ( ! empty( $fsc_item['path'] ) ) : ?><?php echo esc_html( ' (' . $fsc_item['path'] . ')' ); ?><?php endif; ?>
    </option>
<?php endforeach; ?>
    <option value="custom"><?php esc_html_e( 'Custom path (below)', 'file-scan-code-search' ); ?></option>
</select>
<p class="description"><?php esc_html_e( 'Advanced locations are disabled by default. To enable scanning outside WordPress, define FSC_ALLOW_OUTSIDE_WP in wp-config.php.', 'file-scan-code-search' ); ?></p>
                        <input type="text" id="fsc-custom-path" placeholder="<?php echo esc_attr( trailingslashit( ABSPATH ) ); ?>" style="display:none; width: 60%;">
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="fsc-extensions"><?php esc_html_e( 'File Extensions', 'file-scan-code-search' ); ?></label></th>
                    <td><input type="text" id="fsc-extensions" value="php,js,css" class="regular-text"></td>
                </tr>
<tr>
    <th scope="row"><label for="fsc-max-depth"><?php esc_html_e( 'Max depth', 'file-scan-code-search' ); ?></label></th>
    <td>
        <input type="number" id="fsc-max-depth" value="0" min="0" step="1" class="small-text">
        <p class="description"><?php esc_html_e( '0 means unlimited. Use a smaller number to scan faster in very large folders.', 'file-scan-code-search' ); ?></p>
    </td>
</tr>

                <tr>
                    <th scope="row">&nbsp;</th>
                    <td>
                        <label><input type="checkbox" id="fsc-case-sensitive"> <?php esc_html_e( 'Case sensitive', 'file-scan-code-search' ); ?></label>&nbsp;&nbsp;
                        <label><input type="checkbox" id="fsc-regex"> <?php esc_html_e( 'Regex', 'file-scan-code-search' ); ?></label>
                    </td>
                </tr>
            </tbody>
        </table>
        <p class="submit">
            <button type="submit" class="button button-primary" id="fsc-search-btn"><?php esc_html_e( 'Search', 'file-scan-code-search' ); ?></button>
        </p>
    </form>

    <div id="fsc-progress" style="display:none;">
        <div id="fsc-progress-bar"></div>
    </div>

    <h2 id="fsc-results-heading" style="display:none;"><?php esc_html_e( 'Results', 'file-scan-code-search' ); ?></h2>
    <div class="fsc-export-actions" style="display:none;">
        <button class="button" id="fsc-export-csv">CSV</button>
        <button class="button" id="fsc-export-json">JSON</button>
    </div>

    <table class="widefat striped" id="fsc-results-table" style="display:none;">
        <thead>
            <tr>
                <th><?php esc_html_e( 'File Path', 'file-scan-code-search' ); ?></th>
                <th><?php esc_html_e( 'Line', 'file-scan-code-search' ); ?></th>
                <th><?php esc_html_e( 'Snippet', 'file-scan-code-search' ); ?></th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
    <?php elseif ( 'advanced' === $tab ) : ?>
        <div class="card" style="max-width: 980px; padding: 16px;">
            <h2 style="margin-top:0;"><?php esc_html_e( 'Advanced scanning (outside WordPress)', 'file-scan-code-search' ); ?></h2>
            <p><?php esc_html_e( 'By default, the plugin only allows scanning inside the WordPress installation for safety and performance.', 'file-scan-code-search' ); ?></p>

            <p><strong><?php esc_html_e( 'Enable advanced mode (wp-config.php)', 'file-scan-code-search' ); ?></strong></p>
            <p><?php esc_html_e( 'Add the following line to wp-config.php (above “That’s all, stop editing!”):', 'file-scan-code-search' ); ?></p>

            <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>

            <p><?php esc_html_e( 'After enabling this, additional server locations will appear in the Directory dropdown, and custom paths outside WordPress can be validated.', 'file-scan-code-search' ); ?></p>

            <hr />

            <h3><?php esc_html_e( 'Notes', 'file-scan-code-search' ); ?></h3>
            <ul style="list-style: disc; padding-left: 20px;">
                <li><?php esc_html_e( 'Scanning very large folders can be slow. Start with a specific folder (like plugins or uploads).', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'If your server restricts PHP access with open_basedir, some locations may remain disabled.', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'This plugin is read-only and will not modify or delete any files.', 'file-scan-code-search' ); ?></li>
            </ul>

            <hr />

            <h3><?php esc_html_e( 'Same instructions in common languages', 'file-scan-code-search' ); ?></h3>
            <details style="margin-bottom:10px;"><summary><strong>English</strong></summary>
                <p>Add this line to wp-config.php to enable advanced scanning outside WordPress:</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;" dir="rtl"><summary><strong>العربية</strong></summary>
                <p>لتمكين فحص المسارات خارج ووردبريس، أضف السطر التالي داخل ملف wp-config.php قبل جملة الإيقاف:</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;" dir="ltr"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;"><summary><strong>Français</strong></summary>
                <p>Pour activer l’analyse en dehors de WordPress, ajoutez cette ligne dans wp-config.php (avant la ligne “stop editing”):</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;"><summary><strong>Español</strong></summary>
                <p>Para habilitar el escaneo fuera de WordPress, agrega esta línea en wp-config.php (antes de “stop editing”):</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
        </div>

    
    <?php elseif ( 'advanced' === $fscs_tab ) : ?>
        <div class="card" style="max-width: 980px; padding: 16px;">
            <h2 style="margin-top:0;"><?php esc_html_e( 'Advanced scanning (outside WordPress)', 'file-scan-code-search' ); ?></h2>
            <p><?php esc_html_e( 'By default, scanning is limited to the WordPress installation for safety and performance.', 'file-scan-code-search' ); ?></p>

            <p><strong><?php esc_html_e( 'Enable advanced mode (wp-config.php)', 'file-scan-code-search' ); ?></strong></p>
            <p><?php esc_html_e( 'Add the following line to wp-config.php (above the “stop editing” line):', 'file-scan-code-search' ); ?></p>

            <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>

            <hr />

            <h3><?php esc_html_e( 'Same instructions in common languages', 'file-scan-code-search' ); ?></h3>
            <details style="margin-bottom:10px;"><summary><strong>English</strong></summary>
                <p>Add this line to wp-config.php to enable scanning outside WordPress:</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;" dir="rtl"><summary><strong>العربية</strong></summary>
                <p>لتمكين فحص المسارات خارج ووردبريس، أضف السطر التالي داخل ملف wp-config.php قبل جملة الإيقاف:</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;" dir="ltr"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;"><summary><strong>Français</strong></summary>
                <p>Pour activer l’analyse en dehors de WordPress, ajoutez cette ligne dans wp-config.php :</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
            <details style="margin-bottom:10px;"><summary><strong>Español</strong></summary>
                <p>Para habilitar el escaneo fuera de WordPress, agrega esta línea en wp-config.php :</p>
                <pre style="background:#fff; border:1px solid #ccd0d4; padding:12px; overflow:auto;"><code><?php echo esc_html( "define( 'FSC_ALLOW_OUTSIDE_WP', true );" ); ?></code></pre>
            </details>
        </div>

    
    <?php else : ?>
        <div class="card" style="max-width: 980px; padding: 16px;">
            <h2 style="margin-top:0;"><?php esc_html_e( 'How to use', 'file-scan-code-search' ); ?></h2>
            <ol style="padding-left: 20px;">
                <li><?php esc_html_e( 'Select a Directory preset. For best results, choose a specific “Plugin: …” option instead of “Plugins”.', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'Enter Search Text, then run the search.', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'If you use Regex, make sure your pattern is valid.', 'file-scan-code-search' ); ?></li>
            </ol>

            <h3><?php esc_html_e( 'Why you may see no results', 'file-scan-code-search' ); ?></h3>
            <ul style="list-style: disc; padding-left: 20px;">
                <li><?php esc_html_e( 'Large folders can hit safety limits. Pick a smaller directory (like a specific plugin folder).', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'Large files over 1MB are skipped for safety.', 'file-scan-code-search' ); ?></li>
                <li><?php esc_html_e( 'Extensions filter might exclude the file type.', 'file-scan-code-search' ); ?></li>
            </ul>

            <hr />

            <h3><?php esc_html_e( 'About', 'file-scan-code-search' ); ?></h3>
            <p><strong><?php esc_html_e( 'Author:', 'file-scan-code-search' ); ?></strong> <?php echo esc_html( 'Mohamed Saad' ); ?></p>
            <p><strong><?php esc_html_e( 'Author URL:', 'file-scan-code-search' ); ?></strong>
                <a href="<?php echo esc_url( 'https://madebysaad.com' ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html( 'madebysaad.com' ); ?></a>
            </p>
            <p><strong><?php esc_html_e( 'Plugin URL:', 'file-scan-code-search' ); ?></strong>
                <a href="<?php echo esc_url( 'https://madebysaad.com/file-scan-wp-code/' ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html( 'madebysaad.com/file-scan-wp-code/' ); ?></a>
            </p>
        </div>
    
    <?php endif; ?>

</div>
