<?php
/**
 * Plugin Name: File Scan Code Search
 * Plugin URI:  https://madebysaad.com/file-scan-code-search/
 * Description: Scan server files from wp-admin and search code patterns safely (read-only).
 * Version: 1.0.3
 * Requires at least: 5.2
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Author: Mohamed Saad
 * Author URI: https://madebysaad.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: file-scan-code-search
 * Domain Path: /languages
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Plugin constants
if ( ! defined( 'FSC_VERSION' ) ) {
    define( 'FSC_VERSION', '1.0.2' );
}
if ( ! defined( 'FSC_PLUGIN_FILE' ) ) {
    define( 'FSC_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'FSC_PLUGIN_DIR' ) ) {
    define( 'FSC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'FSC_PLUGIN_URL' ) ) {
    define( 'FSC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Load translations.
 */
}

// Load admin part in dashboard only
if ( is_admin() ) {
    require_once FSC_PLUGIN_DIR . 'includes/class-fsc-admin.php';
    \FileScan\FSC_Admin::get_instance();
} 